<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* 
*/
class Cpersona extends CI_Controller
{
	
	function __construct()
	{
		parent::__construct();
		$this->load->model('mpersona');
		$this->load->model('musuario');
		$this->load->library('encrypt');
		if (!$this->session->userdata('s_idUsuario')) {
			redirect('clogin');
		}
	}

	public function index(){
		$this->load->view('layout/header');
		$this->load->view('layout/menu');
		$this->load->view('persona/vpersona');
		$this->load->view('layout/footer');
	}

	public function prueba(){

		$this->load->view('vPrueba');
	}

	public function guardar(){
		//persona
		$param['dni'] = $this->input->post('txtDNI');
		$param['nombre'] = $this->input->post('txtNombre');
		$param['appaterno'] = $this->input->post('txtApPaterno');
		$param['apmaterno'] = $this->input->post('txtApMaterno');
		$param['email'] = $this->input->post('txtEmail');
		$param['fecnac'] = $this->input->post('datFecNac');
		//usuario
		$paramUsu['nomUsuario'] = $this->input->post('txtUsuario');
		$paramUsu['clave'] = $this->encrypt->sha1($this->input->post('txtClave'));
		
		$lastId = $this->mpersona->guardar($param);

		if ($lastId > 0) {
			$paramUsu['idPersona'] = $lastId;
			$this->musuario->guardarUsuario($paramUsu);
		}

	}

	public function actualizarDatos(){
		$param['nombre'] = $this->input->post('txtNombre');
		$param['appaterno'] = $this->input->post('txtApPaterno');
		$param['apmaterno'] = $this->input->post('txtApMaterno');
		$param['email'] = $this->input->post('txtEmail');

		$this->mpersona->actualizarDatos($param);

		//$this->load->view('persona/vpersona');
		redirect('cpersona/index');
	}

	public function eliminarPersona(){
		$idP = $this->input->post('txtIdPersona');

		$this->musuario->eliminarUsuario($idP);
		$this->mpersona->eliminarPersona($idP);
	}

	// public function getPersonas(){
	// 	echo json_encode($this->mpersona->getPersonas());
	// }

	public function getPersonas(){//server side processing

		//parametro inicio
		//para final
		//para de busqueda

		$start = $this->input->post('start');
		$length = $this->input->post('length');
		$search = $this->input->post('search')['value'];



		$result = $this->mpersona->getPersonas($start,$length,$search);

		$resultado = $result['datos'];
		$totalDatos = $result['numDataTotal'];;


		$datos = array();
		foreach ($resultado->result_array() as $row) {
			$array = array();
			$array['rownum'] = $row['rownum'];
			$array['nombre'] = $row['nombre'];
			$array['app'] = $row['app'];
			$array['apmaterno'] = $row['apmaterno'];
			$array['dni'] = $row['dni'];
			$array['ciudad'] = $row['ciudad'];
			$array['intEstado'] = $row['intEstado'];
			$array['idPersona'] = $row['idPersona'];
			$array['email'] = $row['email'];
			$datos[] = $array;
		}

		$totalDatoObtenido = $resultado->num_rows();

		$json_data = array(
            "draw"            => intval($this->input->post('draw')),
            "recordsTotal"    => intval($totalDatoObtenido),
            "recordsFiltered" => intval($totalDatos),
            "data"            => $datos
            );

        echo json_encode($json_data);

	}

	public function updPersona(){
		$param['idPersona'] = $this->input->post('mhdnIdPersona');
		$param['nombre'] = $this->input->post('mtxtNombre');
		$param['appaterno'] = $this->input->post('mtxtApPaterno');
		$param['apmaterno'] = $this->input->post('mtxtApMaterno');
		$param['email'] = $this->input->post('mtxtEmail');

		echo $this->mpersona->updPersona($param);

	}
}